/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.Factories;

import BryceMath.Factories.NumberFactory;
import BryceMath.Numbers.Equation;
import BryceMath.Numbers.Expression;
import BryceMath.Numbers.Multinomial;
import BryceMath.Numbers.Rational;
import Data_Structures.Structures.IterB;
import Data_Structures.Structures.List;
import util.StringParser;
import util.testing;

public class ExpressionFactory {
    public static Multinomial createMultinomial(String mult_string) {
        Expression e = ExpressionFactory.createExpression(mult_string);
        Multinomial num = e.getNum();
        Multinomial denom = e.getDenom();
        if (denom.isComplex()) {
            num = num.div(denom);
        }
        return num;
    }

    public static Equation createEquation(String eq_string) {
        if (eq_string.equals("")) {
            return Equation.ZERO;
        }
        String[] parts = eq_string.split("=");
        String left = parts[0];
        String right = parts.length == 2 ? parts[1] : null;
        Expression out_left = null;
        Expression out_right = null;
        if (!left.equals("")) {
            out_left = ExpressionFactory.createExpression(left);
        }
        if (right != null && !right.equals("")) {
            out_right = ExpressionFactory.createExpression(right);
        }
        if (out_left != null) {
            return new Equation(out_left, out_right);
        }
        if (out_right != null) {
            return new Equation(out_right);
        }
        return Equation.ZERO;
    }

    public static Expression createExpression(String exp_string) {
        if (exp_string.equals("")) {
            return Expression.ZERO;
        }
        List<String> comps = StringParser.parseExpression(exp_string);
        if (comps.isEmpty()) {
            return Expression.ZERO;
        }
        List<Object> output = ExpressionFactory.parseSubExpressions(comps);
        if (output.isEmpty()) {
            return Expression.ZERO;
        }
        ExpressionFactory.sanitizeConnectives(output);
        ExpressionFactory.reduceExpontents(output);
        ExpressionFactory.reduceMultAndDivision(output);
        ExpressionFactory.reduceAddAndSubtraction(output);
        testing.ASSERT(output.size() == 1);
        return (Expression)output.getFirst();
    }

    private static List<Object> parseSubExpressions(List<String> input) {
        List<Object> output = new List<Object>();
        IterB<String> iter2 = input.getIter();
        block5: while (iter2.hasNext()) {
            String str = iter2.next();
            if (StringParser.isConstantNumber(str)) {
                output.add(NumberFactory.E(NumberFactory.R(str)));
                continue;
            }
            testing.ASSERT(str.length() == 1);
            char c = str.charAt(0);
            switch (c) {
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case '^': {
                    output.add(new Character(c));
                    break;
                }
                case '(': 
                case '[': 
                case '{': {
                    testing.ASSERT(iter2.hasNext());
                    output.add(ExpressionFactory.createExpression(iter2.next()));
                    testing.ASSERT(iter2.hasNext());
                    testing.ASSERT(iter2.next().charAt(0) == StringParser.getRightParen(c));
                    break;
                }
                case '\"': 
                case '\'': {
                    testing.ASSERT(iter2.hasNext());
                    String next = iter2.next();
                    if (next.equals(String.valueOf(c))) continue block5;
                    output.add(NumberFactory.E(next));
                    testing.ASSERT(iter2.hasNext());
                    testing.ASSERT(iter2.next().charAt(0) == StringParser.getRightParen(c));
                    break;
                }
                default: {
                    output.add(NumberFactory.E(Rational.ONE, "" + c));
                }
            }
        }
        return output;
    }

    private static void sanitizeConnectives(List<Object> input) {
        Object last;
        Object first = input.getFirst();
        if (first instanceof Character) {
            input.prepend(Expression.ZERO);
        }
        if ((last = input.getLast()) instanceof Character) {
            input.add(Expression.ONE);
        }
        IterB<Object> iter2 = input.getIter();
        boolean charLast = false;
        while (iter2.hasNext()) {
            Object o = iter2.next();
            if (o instanceof Character) {
                if (charLast) {
                    iter2.remove();
                    continue;
                }
                charLast = true;
                continue;
            }
            charLast = false;
        }
    }

    private static void reduceExpontents(List<Object> input) {
        IterB<Object> iter2 = input.getTailIter();
        while (iter2.hasPrevious()) {
            Object o = iter2.previous();
            if (!(o instanceof Character) || ((Character)o).charValue() != '^') continue;
            iter2.remove();
            Expression power = (Expression)iter2.next();
            iter2.remove();
            Expression base = (Expression)iter2.previous();
            iter2.replace(base.pow(power));
        }
    }

    private static void reduceMultAndDivision(List<Object> input) {
        IterB<Object> iter2 = input.getIter();
        Expression product = Expression.ONE;
        while (iter2.hasNext()) {
            Object o = iter2.next();
            if (!(o instanceof Character)) {
                iter2.insertBefore("*");
                iter2.remove();
                product = ExpressionFactory.mult_helper(iter2, product);
                continue;
            }
            char c = ((Character)o).charValue();
            if (c == '*') {
                iter2.remove();
                product = ExpressionFactory.mult_helper(iter2, product);
                continue;
            }
            if (c == '/') {
                iter2.remove();
                product = ExpressionFactory.divide_helper(iter2, product);
                continue;
            }
            iter2.insertBefore(product);
            iter2.next();
            product = Expression.ONE;
        }
    }

    private static Expression mult_helper(IterB<Object> iter2, Expression product) {
        product = product.mult((Expression)iter2.next());
        if (!iter2.hasNext()) {
            iter2.replace(product);
        } else {
            iter2.remove();
        }
        return product;
    }

    private static Expression divide_helper(IterB<Object> iter2, Expression product) {
        product = product.div((Expression)iter2.next());
        if (!iter2.hasNext()) {
            iter2.replace(product);
        } else {
            iter2.remove();
        }
        return product;
    }

    private static void reduceAddAndSubtraction(List<Object> input) {
        IterB<Object> iter2 = input.getIter();
        while (iter2.hasNext()) {
            Object o = iter2.next();
            if (o instanceof Character && ((Character)o).charValue() == '+') {
                iter2.remove();
                Expression term2 = (Expression)iter2.next();
                iter2.remove();
                Expression term1 = (Expression)iter2.previous();
                iter2.replace(term1.add(term2));
                continue;
            }
            if (!(o instanceof Character) || ((Character)o).charValue() != '-') continue;
            iter2.remove();
            Expression subtrahend = (Expression)iter2.next();
            iter2.remove();
            Expression minuend = (Expression)iter2.previous();
            iter2.replace(minuend.sub(subtrahend));
        }
    }
}

